function [vi,vi_dev] = get_v(i)

% Computes vi and vi_dev for player i, where:
% vi(wi,wni) = i's cont payoff in state (wi,wni)
% vi_dev(wi,wni,ai) = i's cont payoff in state (wi,wni) when he deviates to action ai
%
% The algorithm is fixed point iteration. 

% use global

global beta plr Pr_data x_data n NA NY NW jstate

% allocate memory for outputs

vi = zeros(NW(i),NW(n(i)));
vi_dev = zeros(NW(i),NW(n(i)),NA(i));

% set local variables

vip = zeros(NW(i),NW(n(i)));

ITRMAX = 10e+5; % max number of iterations allowed
ERRTOL = 1.0e-7; % relative error tolerance in computing vi

% compute vi by fixed point iteration
 
for itr = 1:ITRMAX
    
    % update vi to vip
    
    vip(:,:) = 0.0;
    
    for wi=1:NW(i); for wni=1:NW(n(i)); % for each (wi,wni) component
        for ai=1:NA(i); for ani=1:NA(n(i)); for yi=1:NY(i); for yni=1:NY(n(i)); % sum over these variables
                            
            prob = plr(i).p(ai,wi)*plr(n(i)).p(ani,wni)*Pr(i,yi,yni,ai,ani);
            util = (1.0-beta)*plr(i).u(ai,yi) + beta*vi(plr(i).wp(wi,ai,yi),plr(n(i)).wp(wni,ani,yni));
            temp = prob*util;
            
            vip(wi,wni) = vip(wi,wni) + temp;
                            
    	end; end; end; end;
    end; end;
    
    % compare vi and vip and decide what to do
    
    if (max(abs(vi-vip))<ERRTOL) 
        break
    else
        vi = vip;
    end
    
    % warning if iterations exhausted
    
    if (itr==ITRMAX) 
        disp('**Warning: itr reached max in get_v')
    end
 
end
    
% compute vi_dev

for wi=1:NW(i); for wni=1:NW(n(i)); for ai=1:NA(i); % for each (wi,wni,ai) component
    
    vi_dev(wi,wni,ai) = 0.0;
    
    for ani=1:NA(n(i)); for yi=1:NY(i); for yni=1:NY(n(i)); % sum over these variables
    
        prob = plr(n(i)).p(ani,wni)*Pr(i,yi,yni,ai,ani);
        util = (1.0-beta)*plr(i).u(ai,yi) + beta*vi(plr(i).wp(wi,ai,yi),plr(n(i)).wp(wni,ani,yni));
        temp = prob*util;
        
        vi_dev(wi,wni,ai) = vi_dev(wi,wni,ai) + temp;
        
    end; end; end
    
end; end; end
